/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteCubeMerger;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.IdenticalMerger;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.IndirectMerger;
import net.minecraft.world.phys.shapes.NonOverlappingMerger;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Shapes {
    public static final double f_166025_ = 1.0E-7;
    public static final double f_166026_ = 1.0E-6;
    private static final VoxelShape f_83037_ = (VoxelShape)Util.m_137537_(() -> {
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(1, 1, 1);
        discretevoxelshape.m_142703_(0, 0, 0);
        return new CubeVoxelShape((DiscreteVoxelShape)discretevoxelshape);
    });
    public static final VoxelShape f_83036_ = Shapes.m_83048_(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape f_83038_ = new ArrayVoxelShape((DiscreteVoxelShape)new BitSetDiscreteVoxelShape(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));

    public static VoxelShape m_83040_() {
        return f_83038_;
    }

    public static VoxelShape m_83144_() {
        return f_83037_;
    }

    public static VoxelShape m_83048_(double p_83049_, double p_83050_, double p_83051_, double p_83052_, double p_83053_, double p_83054_) {
        if (!(p_83049_ > p_83052_ || p_83050_ > p_83053_ || p_83051_ > p_83054_)) {
            return Shapes.m_166049_(p_83049_, p_83050_, p_83051_, p_83052_, p_83053_, p_83054_);
        }
        throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
    }

    public static VoxelShape m_166049_(double p_166050_, double p_166051_, double p_166052_, double p_166053_, double p_166054_, double p_166055_) {
        if (!(p_166053_ - p_166050_ < 1.0E-7 || p_166054_ - p_166051_ < 1.0E-7 || p_166055_ - p_166052_ < 1.0E-7)) {
            int i = Shapes.m_83041_(p_166050_, p_166053_);
            int j = Shapes.m_83041_(p_166051_, p_166054_);
            int k = Shapes.m_83041_(p_166052_, p_166055_);
            if (i >= 0 && j >= 0 && k >= 0) {
                if (i == 0 && j == 0 && k == 0) {
                    return Shapes.m_83144_();
                }
                int l = 1 << i;
                int i1 = 1 << j;
                int j1 = 1 << k;
                BitSetDiscreteVoxelShape bitsetdiscretevoxelshape = BitSetDiscreteVoxelShape.m_165932_((int)l, (int)i1, (int)j1, (int)((int)Math.round(p_166050_ * (double)l)), (int)((int)Math.round(p_166051_ * (double)i1)), (int)((int)Math.round(p_166052_ * (double)j1)), (int)((int)Math.round(p_166053_ * (double)l)), (int)((int)Math.round(p_166054_ * (double)i1)), (int)((int)Math.round(p_166055_ * (double)j1)));
                return new CubeVoxelShape((DiscreteVoxelShape)bitsetdiscretevoxelshape);
            }
            return new ArrayVoxelShape(Shapes.f_83037_.f_83211_, (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166050_, p_166053_}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166051_, p_166054_}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166052_, p_166055_}));
        }
        return Shapes.m_83040_();
    }

    public static VoxelShape m_83064_(AABB p_83065_) {
        return Shapes.m_166049_(p_83065_.f_82288_, p_83065_.f_82289_, p_83065_.f_82290_, p_83065_.f_82291_, p_83065_.f_82292_, p_83065_.f_82293_);
    }

    @VisibleForTesting
    protected static int m_83041_(double p_83042_, double p_83043_) {
        if (!(p_83042_ < -1.0E-7) && !(p_83043_ > 1.0000001)) {
            for (int i = 0; i <= 3; ++i) {
                boolean flag1;
                int j = 1 << i;
                double d0 = p_83042_ * (double)j;
                double d1 = p_83043_ * (double)j;
                boolean flag = Math.abs(d0 - (double)Math.round(d0)) < 1.0E-7 * (double)j;
                boolean bl = flag1 = Math.abs(d1 - (double)Math.round(d1)) < 1.0E-7 * (double)j;
                if (!flag || !flag1) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    protected static long m_83055_(int p_83056_, int p_83057_) {
        return (long)p_83056_ * (long)(p_83057_ / IntMath.gcd((int)p_83056_, (int)p_83057_));
    }

    public static VoxelShape m_83110_(VoxelShape p_83111_, VoxelShape p_83112_) {
        return Shapes.m_83113_(p_83111_, p_83112_, BooleanOp.f_82695_);
    }

    public static VoxelShape m_83124_(VoxelShape p_83125_, VoxelShape ... p_83126_) {
        return Arrays.stream(p_83126_).reduce(p_83125_, Shapes::m_83110_);
    }

    public static VoxelShape m_83113_(VoxelShape p_83114_, VoxelShape p_83115_, BooleanOp p_83116_) {
        return Shapes.m_83148_(p_83114_, p_83115_, p_83116_).m_83296_();
    }

    public static VoxelShape m_83148_(VoxelShape p_83149_, VoxelShape p_83150_, BooleanOp p_83151_) {
        if (p_83151_.m_82701_(false, false)) {
            throw Util.m_137570_(new IllegalArgumentException());
        }
        if (p_83149_ == p_83150_) {
            return p_83151_.m_82701_(true, true) ? p_83149_ : Shapes.m_83040_();
        }
        boolean flag = p_83151_.m_82701_(true, false);
        boolean flag1 = p_83151_.m_82701_(false, true);
        if (p_83149_.m_83281_()) {
            return flag1 ? p_83150_ : Shapes.m_83040_();
        }
        if (p_83150_.m_83281_()) {
            return flag ? p_83149_ : Shapes.m_83040_();
        }
        IndexMerger indexmerger = Shapes.m_83058_(1, p_83149_.m_7700_(Direction.Axis.X), p_83150_.m_7700_(Direction.Axis.X), flag, flag1);
        IndexMerger indexmerger1 = Shapes.m_83058_(indexmerger.size() - 1, p_83149_.m_7700_(Direction.Axis.Y), p_83150_.m_7700_(Direction.Axis.Y), flag, flag1);
        IndexMerger indexmerger2 = Shapes.m_83058_((indexmerger.size() - 1) * (indexmerger1.size() - 1), p_83149_.m_7700_(Direction.Axis.Z), p_83150_.m_7700_(Direction.Axis.Z), flag, flag1);
        BitSetDiscreteVoxelShape bitsetdiscretevoxelshape = BitSetDiscreteVoxelShape.m_82641_((DiscreteVoxelShape)p_83149_.f_83211_, (DiscreteVoxelShape)p_83150_.f_83211_, (IndexMerger)indexmerger, (IndexMerger)indexmerger1, (IndexMerger)indexmerger2, (BooleanOp)p_83151_);
        return indexmerger instanceof DiscreteCubeMerger && indexmerger1 instanceof DiscreteCubeMerger && indexmerger2 instanceof DiscreteCubeMerger ? new CubeVoxelShape((DiscreteVoxelShape)bitsetdiscretevoxelshape) : new ArrayVoxelShape((DiscreteVoxelShape)bitsetdiscretevoxelshape, indexmerger.m_6241_(), indexmerger1.m_6241_(), indexmerger2.m_6241_());
    }

    public static boolean m_83157_(VoxelShape p_83158_, VoxelShape p_83159_, BooleanOp p_83160_) {
        if (p_83160_.m_82701_(false, false)) {
            throw Util.m_137570_(new IllegalArgumentException());
        }
        boolean flag = p_83158_.m_83281_();
        boolean flag1 = p_83159_.m_83281_();
        if (!flag && !flag1) {
            if (p_83158_ == p_83159_) {
                return p_83160_.m_82701_(true, true);
            }
            boolean flag2 = p_83160_.m_82701_(true, false);
            boolean flag3 = p_83160_.m_82701_(false, true);
            for (Direction.Axis direction$axis : AxisCycle.f_121783_) {
                if (p_83158_.m_83297_(direction$axis) < p_83159_.m_83288_(direction$axis) - 1.0E-7) {
                    return flag2 || flag3;
                }
                if (!(p_83159_.m_83297_(direction$axis) < p_83158_.m_83288_(direction$axis) - 1.0E-7)) continue;
                return flag2 || flag3;
            }
            IndexMerger indexmerger = Shapes.m_83058_(1, p_83158_.m_7700_(Direction.Axis.X), p_83159_.m_7700_(Direction.Axis.X), flag2, flag3);
            IndexMerger indexmerger1 = Shapes.m_83058_(indexmerger.size() - 1, p_83158_.m_7700_(Direction.Axis.Y), p_83159_.m_7700_(Direction.Axis.Y), flag2, flag3);
            IndexMerger indexmerger2 = Shapes.m_83058_((indexmerger.size() - 1) * (indexmerger1.size() - 1), p_83158_.m_7700_(Direction.Axis.Z), p_83159_.m_7700_(Direction.Axis.Z), flag2, flag3);
            return Shapes.m_83103_(indexmerger, indexmerger1, indexmerger2, p_83158_.f_83211_, p_83159_.f_83211_, p_83160_);
        }
        return p_83160_.m_82701_(!flag, !flag1);
    }

    private static boolean m_83103_(IndexMerger p_83104_, IndexMerger p_83105_, IndexMerger p_83106_, DiscreteVoxelShape p_83107_, DiscreteVoxelShape p_83108_, BooleanOp p_83109_) {
        return !p_83104_.m_6200_((p_83100_, p_83101_, p_83102_) -> p_83105_.m_6200_((p_166046_, p_166047_, p_166048_) -> p_83106_.m_6200_((p_166036_, p_166037_, p_166038_) -> !p_83109_.m_82701_(p_83107_.m_82846_(p_83100_, p_166046_, p_166036_), p_83108_.m_82846_(p_83101_, p_166047_, p_166037_)))));
    }

    public static double m_193135_(Direction.Axis p_193136_, AABB p_193137_, Iterable<VoxelShape> p_193138_, double p_193139_) {
        for (VoxelShape voxelshape : p_193138_) {
            if (Math.abs(p_193139_) < 1.0E-7) {
                return 0.0;
            }
            p_193139_ = voxelshape.m_83259_(p_193136_, p_193137_, p_193139_);
        }
        return p_193139_;
    }

    public static boolean m_83117_(VoxelShape p_83118_, VoxelShape p_83119_, Direction p_83120_) {
        if (p_83118_ == Shapes.m_83144_() && p_83119_ == Shapes.m_83144_()) {
            return true;
        }
        if (p_83119_.m_83281_()) {
            return false;
        }
        Direction.Axis direction$axis = p_83120_.m_122434_();
        Direction.AxisDirection direction$axisdirection = p_83120_.m_122421_();
        VoxelShape voxelshape = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_83118_ : p_83119_;
        VoxelShape voxelshape1 = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_83119_ : p_83118_;
        BooleanOp booleanop = direction$axisdirection == Direction.AxisDirection.POSITIVE ? BooleanOp.f_82685_ : BooleanOp.f_82683_;
        return DoubleMath.fuzzyEquals((double)voxelshape.m_83297_(direction$axis), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)voxelshape1.m_83288_(direction$axis), (double)0.0, (double)1.0E-7) && !Shapes.m_83157_((VoxelShape)new SliceShape(voxelshape, direction$axis, voxelshape.f_83211_.m_82850_(direction$axis) - 1), (VoxelShape)new SliceShape(voxelshape1, direction$axis, 0), booleanop);
    }

    public static VoxelShape m_83121_(VoxelShape p_83122_, Direction p_83123_) {
        int i;
        boolean flag;
        if (p_83122_ == Shapes.m_83144_()) {
            return Shapes.m_83144_();
        }
        Direction.Axis direction$axis = p_83123_.m_122434_();
        if (p_83123_.m_122421_() == Direction.AxisDirection.POSITIVE) {
            flag = DoubleMath.fuzzyEquals((double)p_83122_.m_83297_(direction$axis), (double)1.0, (double)1.0E-7);
            i = p_83122_.f_83211_.m_82850_(direction$axis) - 1;
        } else {
            flag = DoubleMath.fuzzyEquals((double)p_83122_.m_83288_(direction$axis), (double)0.0, (double)1.0E-7);
            i = 0;
        }
        return !flag ? Shapes.m_83040_() : new SliceShape(p_83122_, direction$axis, i);
    }

    public static boolean m_83152_(VoxelShape p_83153_, VoxelShape p_83154_, Direction p_83155_) {
        if (p_83153_ != Shapes.m_83144_() && p_83154_ != Shapes.m_83144_()) {
            VoxelShape voxelshape1;
            Direction.Axis direction$axis = p_83155_.m_122434_();
            Direction.AxisDirection direction$axisdirection = p_83155_.m_122421_();
            VoxelShape voxelshape = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_83153_ : p_83154_;
            VoxelShape voxelShape = voxelshape1 = direction$axisdirection == Direction.AxisDirection.POSITIVE ? p_83154_ : p_83153_;
            if (!DoubleMath.fuzzyEquals((double)voxelshape.m_83297_(direction$axis), (double)1.0, (double)1.0E-7)) {
                voxelshape = Shapes.m_83040_();
            }
            if (!DoubleMath.fuzzyEquals((double)voxelshape1.m_83288_(direction$axis), (double)0.0, (double)1.0E-7)) {
                voxelshape1 = Shapes.m_83040_();
            }
            return !Shapes.m_83157_(Shapes.m_83144_(), Shapes.m_83148_((VoxelShape)new SliceShape(voxelshape, direction$axis, voxelshape.f_83211_.m_82850_(direction$axis) - 1), (VoxelShape)new SliceShape(voxelshape1, direction$axis, 0), BooleanOp.f_82695_), BooleanOp.f_82685_);
        }
        return true;
    }

    public static boolean m_83145_(VoxelShape p_83146_, VoxelShape p_83147_) {
        if (p_83146_ != Shapes.m_83144_() && p_83147_ != Shapes.m_83144_()) {
            if (p_83146_.m_83281_() && p_83147_.m_83281_()) {
                return false;
            }
            return !Shapes.m_83157_(Shapes.m_83144_(), Shapes.m_83148_(p_83146_, p_83147_, BooleanOp.f_82695_), BooleanOp.f_82685_);
        }
        return true;
    }

    @VisibleForTesting
    protected static IndexMerger m_83058_(int p_83059_, DoubleList p_83060_, DoubleList p_83061_, boolean p_83062_, boolean p_83063_) {
        long k;
        int i = p_83060_.size() - 1;
        int j = p_83061_.size() - 1;
        if (p_83060_ instanceof CubePointRange && p_83061_ instanceof CubePointRange && (long)p_83059_ * (k = Shapes.m_83055_(i, j)) <= 256L) {
            return new DiscreteCubeMerger(i, j);
        }
        if (p_83060_.getDouble(i) < p_83061_.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(p_83060_, p_83061_, false);
        }
        if (p_83061_.getDouble(j) < p_83060_.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(p_83061_, p_83060_, true);
        }
        return i == j && Objects.equals(p_83060_, p_83061_) ? new IdenticalMerger(p_83060_) : new IndirectMerger(p_83060_, p_83061_, p_83062_, p_83063_);
    }

    public static interface DoubleLineConsumer {
        public void m_83161_(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

